$(document).ready(function () {
    call_customers_listing();
    $('.tooltip_show').tooltip();
    if ($("#masters_customers_tabs").length > 0) {
        $("#masters_customers_tabs").removeClass("page_header_defaultbtn").addClass("page_header_btn");
    }
    $("#searchContactBlock").show();
});

function call_customers_listing()
{
    $("#searchContactBlock").show();
    $.get($("#hid_customers_url").val() + "vendors_list.php", {"_": $.now()}, function (result) {
        $("#loader_content").html(result);
    });
}


function add_new_customer()
{
    $('.tooltip_show').tooltip('hide');
    $("#searchContactBlock").hide();
    $("#loader_content").html('<div id="alltasksWrapper"><div class="minHeight"><div class="loading" style="text-align:center;"><img src="../img/loading.gif" width="240"/></div></div></div>');
    $.get($("#hid_customers_url").val() + "vendor_add.php", {"_": $.now()}, function (result) {
        $("#loader_content").html(result);
    });
}
function go_to_list() {
    window.location.href = "master-customers-base.php";
}

function edit_vendor(vendor_id)
{
    $('.tooltip_show').tooltip('hide');
    $("#searchContactBlock").hide();
    $("#loader_content").html('<div id="alltasksWrapper"><div class="minHeight"><div class="loading" style="text-align:center;"><img src="../img/loading.gif" width="240"/></div></div></div>');
    $.get($("#hid_customers_url").val() + "vendor_edit.php?vendor_id=" + vendor_id, {"_": $.now()}, function (result) {
        $("#loader_content").html(result);
    });
}
function add() {
    
    $('#frm_add').validate();
    var validationResult = $('#frm_add').valid();
    var user_id = $("#hid_session_user_id").val();
    if (validationResult == true)
    {
        $("#btn_add").attr("onclick","");
        var frmdata = $('#frm_add').serialize();  // alert(frmdata);
        $.ajax({
            type: "POST",
            url: $("#hid_customers_url").val() + "components/vendor_add_save.php?user_id=" + user_id + "&from=" + $("#hid_add_from").val(),
            data: frmdata,
            success: function (msg) {
                $("#loader_content").html('<div id="alltasksWrapper"><div class="minHeight"><div class="loading" style="text-align:center;"><img src="../img/loading.gif" width="240"/></div></div></div>');
                call_customers_listing();
                if ($("#hid_add_from").val() != 2) {
                    stickytester('Customer has been added successfully.');
                } else {
                    sticky_notifications('Customer has been added successfully.', {type: "success"});
                }
            }
        });
    }
}

function update() {
    
    $('#frm_edit').validate();
    var validationResultedit_user = $('#frm_edit').valid();
    var user_id = $("#hid_session_user_id").val();
    if (validationResultedit_user == true)
    {
        $("#btn_edit").attr("onclick","");
        var frmdata = $('#frm_edit').serialize();
        $.ajax({
            type: "POST",
            url: $("#hid_customers_url").val() + "components/vendor_edit_save.php?user_id=" + user_id,
            data: frmdata,
            success: function (msg) {
                $("#loader_content").html('<div id="alltasksWrapper"><div class="minHeight"><div class="loading" style="text-align:center;"><img src="../img/loading.gif" width="240"/></div></div></div>');
                call_customers_listing();
                if ($("#hid_add_from").val() != 2) {
                    stickytester('Customer has been updated successfully.');
                } else {
                    sticky_notifications('Customer has been updated successfully.', {type: "success"});
                }
            }
        });
    }
}


function select_all()
{
    var choose_val = $('input[name=select_all]').is(':checked');
    if (choose_val == true)
    {
        $('input:checkbox').attr('checked', 'checked');
    } else
    {
        $('input:checkbox').removeAttr('checked');
    }
}

function delete_confirm(type, id) {

    if (typeof id !== "undefined") {
        $("#hid_delele_ids").val(id);
    }
    if (type != "single") {
        var check_val = "";
        $("input[type='checkbox']:checked").each(
                function ()
                {
                    if (check_val != "")
                    {
                        check_val = check_val + ",";
                    }
                    check_val = check_val + $(this).val();
                }
        );
        if (check_val != '')
        {
            if (confirm("Are you sure you want to delete this record(s)?\nClick on OK to proceed."))
            {
                $("#hid_delele_ids").val(check_val);
                delete_call(type);
            }
        } else
        {
            if ($("#hid_add_from").val() != 2) {
                stickytester('Please choose at least one record.');
            } else {
                sticky_notifications('Please choose at least one record.', {type: "error"});
            }

        }
    } else {
        if (confirm("Are you sure you want to delete this record(s)?\nClick on OK to proceed."))
        {
            delete_call(type);
        }
    }

}
function delete_call(type) {
    $.ajax({
        type: "POST",
        url: $("#hid_customers_url").val() + "components/delete_vendor.php?type=" + type + "&delete_ids=" + $("#hid_delele_ids").val(),
        success: function (msg) {
            var msg = $.trim(msg);
            if (msg == "success") {
                call_customers_listing();
                stickytester('Customer has been deleted successfully.');
            }
        }
    });
}
function customer_paging_access(page_name, page_num)
{
    $("html, body").animate({
        scrollTop: 0
    }, "slow");
    var page_params = $("#hid_paging_params").val();
    $("#loader_content").html('<div id="alltasksWrapper"><div class="minHeight"><div class="loading" style="text-align:center;"><img src="../img/loading.gif" width="240"/></div></div></div>');
    $.get($("#hid_customers_url").val() + page_name + "?page=" + page_num + "&" + page_params, function (result) {
        $("#loader_content").html(result);
        tooltip_init();
    });
}

function search_customers() {
    if ($("#search_name").val() != "" || $("#search_code").val() != "") {
        $("#search_err").hide();
        var frmdata = $('#search').serialize();
        $("#loader_content").html('<div id="alltasksWrapper"><div class="minHeight"><div class="loading" style="text-align:center;"><img src="../images/loading.gif" width="240"/></div></div></div>');
        $.ajax({
            beforeSend: function () {
                $('#search_process_loader').show();
            },
            complete: function () {
                $('#search_process_loader').hide();
            },
            type: "POST",
            url: $("#hid_customers_url").val() + "vendors_list.php",
            data: frmdata,
            success: function (result) {
                $("#loader_content").html(result);
            }
        });
    } else {
        $("#search_err").show();
    }

}
function export_vendors() {
    var frmdata = $('#search').serialize();
    $.ajax({
        type: "POST",
        url: $("#hid_customers_url").val() + "export_customers.php",
        data: frmdata,
        beforeSend: function () {
            $('#search_process_loader').show();
        },
        complete: function () {
            $('#search_process_loader').hide();
        },
        success: function (result) {
            var res = $.trim(result).split("|");
            if (res[0] == "success") {
                window.location.href = $("#hid_customers_url").val() + 'download.php?filename=reports/' + res[1];
            }
        }
    });
}