$(document).ready(function () {
    init_gst_switchable();
    var state_mapped, state_labels;
    $("#state").typeahead({
        minLength: 1,
        source: function (query, process) {
            $.post($("#hid_customers_url").val() + "components/get-state-list.php?term=" + $('#state').val(), {
                q: query,
                limit: 10
            }, function (data) {
                state_labels = [];
                state_mapped = {};
                var obj = jQuery.parseJSON(data);
                $.each(obj, function (i, item) {
                    state_mapped[item.name] = item.name + "|" + item.abbreviation;
                    state_labels.push(item.name)
                });
                process(JSON.parse(JSON.stringify(state_labels)));
            });
        },
        updater: function (item) {
            var state_name = state_mapped[item].split("|")[0];
            var state_code = state_mapped[item].split("|")[1];
            $("#state_code").val(state_code);
            return item;
        }
    });

    $('#frm_add').validate({
        onkeyup: false,
        errorClass: 'error',
        validClass: 'valid',
        rules: {
            name: {
                required: true,
                checkExist: true
            },
            address: {
                required: true,
                maxlength: 80
            },
            address_2: {
                maxlength: 80
            },
            address_3: {
                maxlength: 80
            },
            cin_number: {
                /* required: true */
            },
            stn_number: {
                /* required: true */
            },
            country: {
                required: true
            },
            pan_number: {
                /* required: true */
            },
            phone: {
                required: true
            },
            contact_person_email_id: {
                email: true
            },
            ceo_email_id: {
                email: true
            }
        },
        messages: {
            name: {
                required: "Vendor name cannot be blank.",
                checkExist: "Vendor already exists."
            },
            address: {
                required: "Address cannot be blank.",
                maxlength: "Address cannot be more than 80 characters."
            },
            address_2: {
                maxlength: "Address cannot be more than 80 characters."
            },
            address_3: {
                maxlength: "Address cannot be more than 80 characters."
            },
            cin_number: {
                required: "CIN number cannot be blank."
            },
            stn_number: {
                required: "Service Tax number cannot be blank."
            },
            country: {
                required: "Country cannot be blank."
            },
            phone: {
                required: "Phone number cannot be blank."
            },
            pan_number: {
                required: "PAN number cannot be blank."
            },
            contact_person_email_id: {
                email: "Please enter a valid Email ID."
            },
            ceo_email_id: {
               email: "Please enter a valid Email ID."
            }
        },
        highlight: function (element) {
            $(element).closest('div').addClass("u_error");
        },
        unhighlight: function (element) {
            $(element).closest('div').removeClass("u_error");
        },
        errorPlacement: function (error, element) {
            $(element).closest('div').append(error);
        }
    });

    $('#frm_edit').validate({
        onkeyup: false,
        errorClass: 'error',
        validClass: 'valid',
        rules: {
            name: {
                required: true,
                checkExist: true
            },
            country: {
                required: true
            },
            pan_number: {
                /* required: true */
            },
            phone: {
                required: true
            },
            address: {
                required: true,
                maxlength: 80
            },
            address_2: {
                maxlength: 80
            },
            address_3: {
                maxlength: 80
            },
            contact_person_email_id: {
                email: true
            }
        },
        messages: {
            name: {
                required: "Vendor name cannot be blank.",
                checkExist: "Vendor name already exists."
            },
            country: {
                required: "Country cannot be blank."
            },
            phone: {
                required: "Phone number cannot be blank."
            },
            pan_number: {
                /* required: "PAN number cannot be blank." */
            },
            address: {
                required: "Address cannot be blank.",
                maxlength: "Address cannot be more than 80 characters."
            },
            address_2: {
                maxlength: "Address cannot be more than 80 characters."
            },
            address_3: {
                maxlength: "Address cannot be more than 80 characters."
            },
            contact_person_email_id: {
                email: "Please enter a valid Email ID."
            }
        },
        highlight: function (element) {
            $(element).closest('div').addClass("u_error");
        },
        unhighlight: function (element) {
            $(element).closest('div').removeClass("u_error");
        },
        errorPlacement: function (error, element) {
            $(element).closest('div').append(error);
        }
    });
    $("#address").bind('blur keyup', function (event) {
        if (event.type == 'blur') {
            $('#address_err').hide();
        } else {
            $("#js_add_err").hide();
            var msg_character = $("#address").val().length;
            var result = 80 - parseInt(msg_character);
            if (result <= 0) {
                $('#address_err').html('You have reached your maximum limit of 80 characters allowed.');
                $('#address_err').fadeIn("slow");
            } else {
                $('#address_err').html(result + ' characters remaining.');
                $('#address_err').fadeIn("slow");
            }
        }
    });

    $("#address_2").bind('blur keyup', function (event) {
        if (event.type == 'blur') {
            $('#address_err_2').hide();
        } else {
            $("#js_add_err_2").hide();
            var msg_character = $("#address_2").val().length;
            var result = 80 - parseInt(msg_character);
            if (result <= 0) {
                $('#address_err_2').html('You have reached your maximum limit of 80 characters allowed.');
                $('#address_err_2').fadeIn("slow");
            } else {
                $('#address_err_2').html(result + ' characters remaining.');
                $('#address_err_2').fadeIn("slow");
            }
        }
    });

    $("#address_3").bind('blur keyup', function (event) {
        if (event.type == 'blur') {
            $('#address_err_3').hide();
        } else {
            $("#js_add_err_2").hide();
            var msg_character = $("#address_3").val().length;
            var result = 80 - parseInt(msg_character);
            if (result <= 0) {
                $('#address_err_3').html('You have reached your maximum limit of 80 characters allowed.');
                $('#address_err_3').fadeIn("slow");
            } else {
                $('#address_err_3').html(result + ' characters remaining.');
                $('#address_err_3').fadeIn("slow");
            }
        }
    });
});
$.validator.addMethod('checkExist',
        function (value) {
            var response;
            var name = $("#name").val();
            var url = "";
            if ($("#hid_update_vendor_id").length > 0) {
                url = $("#hid_customers_url").val() + "components/check-vendor-exist.php?vendor_id=" + $("#hid_update_vendor_id").val() + "&name=" + name;
            } else {
                url = $("#hid_customers_url").val() + "components/check-vendor-exist.php?name=" + name;
            }
            $.ajax({
                async: false,
                type: "POST",
                url: url,
                success: function (msg) {
                    response = $.trim(msg);
                }
            });
            if (response == "true")
            {
                return true;
            } else
            {
                return false;
            }
        });
function init_gst_switchable() {
    $(".cb-enable").click(function () {
        var parent = $(this).parents('.switch');
        var type = $(this).data("type");
        $('.cb-disable', parent).removeClass('selected');
        $(this).addClass('selected');
        if(type==1){
            parent.find("input:radio[value='1']").attr("checked", true);
            parent.find("input:radio[value='2']").attr("checked", false);
        }else if(type == 2){
            parent.find("input:radio[value='0']").attr("checked", true);
            parent.find("input:radio[value='1']").attr("checked", false);
        }
        //init_generate_fn();
    });
    $(".cb-disable").click(function () {
        var parent = $(this).parents('.switch');
        var type = $(this).data("type");
        $('.cb-enable', parent).removeClass('selected');
        $(this).addClass('selected');
        if(type==1){
            parent.find("input:radio[value='2']").attr("checked", true);
            parent.find("input:radio[value='1']").attr("checked", false);
        }else if(type == 2){
            parent.find("input:radio[value='1']").attr("checked", true);
            parent.find("input:radio[value='0']").attr("checked", false);
        }
        //init_generate_fn();
    });
}
