<?php

require("../config/config.php");

$event_data = @file_get_contents('php://input');

$json_data = json_decode($event_data, true);

if (empty($json_data)) {
    echo '{"response":"0","message":"Invalid JSON Format"}';
    die();
}

$api_key = $json_data["authentication"]["api_key"];

if (empty($api_key)) {
    echo '{"response":"0","message":"API key cannot be blank"}';
    die();
}

if ($api_key != GLOBAL_APP_API_KEY) {
    echo '{"response":"0","message":"Invalid API Key"}';
    die();
}

$vertical = $json_data["authentication"]["event_data"]["vertical"];
$status = $json_data["authentication"]["event_data"]["status"];
$erp_record_id = $json_data["authentication"]["event_data"]["erp_record_id"];
$event_name = $json_data["authentication"]['event_data']['event_name'];
$event_code = $json_data["authentication"]['event_data']['event_code'];
$event_description = $json_data["authentication"]['event_data']['description'];

$originalDate = $json_data["authentication"]['event_data']['start_date'];
$event_start_date = date("Y-m-d", strtotime($originalDate));

$originalEndDate = $json_data["authentication"]['event_data']['end_date'];
$event_end_date = date("Y-m-d", strtotime($originalEndDate));

$table_name = "";
$exhibition_table = "";
if(!empty($vertical)){
    switch($vertical){
        case "IMTEX":
            $table_name = "imtexeventdb";
            $exhibition_table = "biec_exhibition";
            $data['is_pushed'] = 1;
            break;
        case "DMTX":
            $table_name = "dmtxeventdb";
            $exhibition_table = "biec_exhibition";
            $data['is_pushed'] = 1;
            break;	
        case "BIEC":
            $table_name = "bieceventdb";
            $exhibition_table = "billing_shows";
            $data['push_status'] = 1;
            break;
        default:
            break;
    }
}
$insert_data['value'] = $event_code;

$insert_data['description'] = $event_description;
$insert_data['eventStartDate'] = $event_start_date;
$insert_data['eventEndDate'] = $event_end_date;

$recordID = $db_erp->query_insert($table_name, $insert_data);
$db_erp->close();

 if($vertical == "IMTEX"){
    $db = new mysqlconnect(DB_IMTEX_SERVER, DB_IMTEX_USER, DB_IMTEX_PASS, DB_IMTEX_DATABASE);
    $db->connect();
}else if($vertical == "DMTX"){
    $db = new mysqlconnect(DB_DMTX_SERVER, DB_DMTX_USER, DB_DMTX_PASS, DB_DMTX_DATABASE);
    $db->connect();
}else{
    $db = new mysqlconnect(DB_BIEC_SERVER, DB_BIEC_USER, DB_BIEC_PASS, DB_BIEC_DATABASE);
    $db->connect();
}

$db->query_update($exhibition_table, $data, "event_code='".$event_code."'");
unset($data);
$db->close();

if (!empty($recordID)) {
    echo '{"response":"1","message":"Success"}';
}

die();
?>
