<?php

require("../config/config.php");

$customer_data = @file_get_contents('php://input');

$json_data = json_decode($customer_data, true);

if (empty($json_data)) {
    echo '{"response":"0","message":"Invalid JSON Format"}';
    die();
}

$api_key = $json_data["authentication"]["api_key"];

if (empty($api_key)) {
    echo '{"response":"0","message":"API key cannot be blank"}';
    die();
}

if ($api_key != GLOBAL_APP_API_KEY) {
    echo '{"response":"0","message":"Invalid API Key"}';
    die();
}

$customer_group = $json_data["authentication"]["customer_data"]['vendor_group'];
if($customer_group == "NONMEMFORE"){
	$currency = "USD";
}else{
	$currency = "INR";
}

$membershipNumber = $json_data["authentication"]["customer_data"]['code'];
$insert_data["companyName"] = cleanData($json_data["authentication"]["customer_data"]['name']);
$insert_data["membershipNumber"] = $membershipNumber;
$insert_data['memberType'] = $json_data["authentication"]["customer_data"]['vendor_group'];
$insert_data["currency"] = $currency;
$insert_data["panNumber"] = cleanData($json_data["authentication"]["customer_data"]['pan_number']);
$insert_data["serviceTaxNo"] = cleanData($json_data["authentication"]["customer_data"]['stn_number']);
$insert_data["finDim"] = $json_data["authentication"]["customer_data"]['vendor_group'];
$insert_data["type"] = "Business, Home";
//$insert_data["locationDescription"] = $json_data["authentication"]["customer_data"]['customer_state'];
$insert_data["street"] = cleanData($json_data["authentication"]["customer_data"]['address']);

$insert_data["city"] = cleanData($json_data["authentication"]["customer_data"]['city_code']);
$insert_data["cityDescription"] = cleanData($json_data["authentication"]["customer_data"]['city']);
$insert_data["state"] = cleanData($json_data["authentication"]["customer_data"]['state_code']);
$insert_data["stateDescription"] = cleanData($json_data["authentication"]["customer_data"]['state']);
$insert_data["country"] = cleanData($json_data["authentication"]["customer_data"]['country']);
$insert_data["zipCode"] = cleanData($json_data["authentication"]["customer_data"]['pin']);
$insert_data["gstNumber"] = cleanData($json_data["authentication"]["customer_data"]['gst_number']);

$sac = cleanData($json_data["authentication"]["customer_data"]['sac']);
if(empty($sac) || $sac < 0){
    $sac = 0;
}
$insert_data["sac"] = $sac;

$customer_from = $json_data["authentication"]["customer_data"]['vendor_from'];
$table_name = "";
if($customer_from == 1){ // IMTEX - biec application
	$table_name = "imtexexhibitorstagingdb";
}else if($customer_from == 2){ // Billing
	$table_name = "biecexhibitorstagingdb"; 
}else if($customer_from == 3){ // DMTX
	$table_name = "dmtxexhibitorstagingdb";
}

/* $sql = "select recordID from ".$table_name." where membershipNumber ='".$membershipNumber."'";
$result = $db_erp->query_first($sql);

if($db_erp->affected_rows > 0){
    $recordID = $result['recordID'];
    $db_erp->query_update($table_name, $insert_data, "recordID=" . $recordID);
}else{
    $recordID = $db_erp->query_insert($table_name, $insert_data);
} */
$recordID = $db_erp->query_insert($table_name, $insert_data);

if (!empty($recordID)) {
    echo '{"response":"1","message":"success"}';
}


$db_erp->close();
die();
?>
