<?php

require("../config/config.php");

$payment_data = @file_get_contents('php://input');

$json_data = json_decode($payment_data, true);

if (empty($json_data)) {
    echo '{"response":"0","message":"Invalid JSON Format"}';
    die();
}

$api_key = $json_data["authentication"]["api_key"];

if (empty($api_key)) {
    echo '{"response":"0","message":"API key cannot be blank"}';
    die();
}

if ($api_key != GLOBAL_APP_API_KEY) {
    echo '{"response":"0","message":"Invalid API Key"}';
    die();
}

$membershipNumber = $json_data["authentication"]["payment_data"]["membershipNumber"];
$journalName = $json_data["authentication"]['payment_data']['journalName'];
$custAccount = $json_data["authentication"]['payment_data']['custAccount'];
$markedInvoice = $json_data["authentication"]['payment_data']['markedInvoice'];
$transDate = $json_data["authentication"]['payment_data']['transDate'];
$prePayment = $json_data["authentication"]['payment_data']['prePayment'];
$paymentMode = $json_data["authentication"]['payment_data']['paymentMode'];

$bankName = $json_data["authentication"]['payment_data']['backName'];
$amount = $json_data["authentication"]['payment_data']['amount'];
$currency = $json_data["authentication"]['payment_data']['currency'];
$documentNo = $json_data['authentication']['payment_data']['documentNo'];

$gstNumber = $json_data["authentication"]['payment_data']['gstNumber'];
$stateCode = $json_data["authentication"]['payment_data']['stateCode'];
$sac = $json_data['authentication']['payment_data']['sac'];

$insert_data['journalname'] = $journalName;

$extract_number = ltrim(preg_replace("/[^0-9]/","",$custAccount), '0');
$insert_data['custaccount'] = $extract_number;

$insert_data['markedinvoice'] = $markedInvoice;
$insert_data['prepayment'] = $prePayment;

if($paymentMode == "Demand Draft"){
    $insert_data['paymmode'] = "DD"; 
}else if($paymentMode == "TDS Certificate"){
    $insert_data['paymmode'] = "TDS"; 
}else{
    $insert_data['paymmode'] = $paymentMode; 
}

if($json_data["authentication"]['payment_data']['paymentMode']=="Cash"){
	$insert_data['isCash'] = 1;
}
$insert_data['bankaccount'] = "";
$insert_data['transdate'] = $transDate;
$insert_data['documentno'] = $documentNo;
$insert_data['amount'] = $amount;
$insert_data['currency'] = $currency;

$insert_data['gstNumber'] = $gstNumber;
$insert_data['stateCode'] = $stateCode;
$insert_data['sac'] = $sac;

$insert_data['vertical'] = "MEMBERSHIP";

$insert_id = $db_erp->query_insert("memberpaymjournalstagingdb", $insert_data);

if (!empty($insert_id)) {
    echo '{"response":"1","message":"success"}';
}

$db_erp->close();
die();
?>
