<?php

require("../config/config.php");

$invoice_data = @file_get_contents('php://input');
$json_data = json_decode($invoice_data, true);

if (empty($json_data)) {
    echo '{"response":"0","message":"Invalid JSON Format"}';
    die();
}

$api_key = $json_data["authentication"]["api_key"];

if (empty($api_key)) {
    echo '{"response":"0","message":"API key cannot be blank"}';
    die();
}

if ($api_key != GLOBAL_APP_API_KEY) {
    echo '{"response":"0","message":"Invalid API Key"}';
    die();
}

$vertical = $json_data["authentication"]["vertical"];

$code = $json_data["authentication"]["invoice_data"]["code"];
$street = $json_data["authentication"]['invoice_data']['street'];
$cityCode = $json_data["authentication"]['invoice_data']['cityCode'];
$cityDescription = $json_data["authentication"]['invoice_data']['cityDescription'];
$stateCode = $json_data["authentication"]['invoice_data']['stateCode'];
$stateDescription = $json_data["authentication"]['invoice_data']['stateDescription'];
$countryCode = $json_data["authentication"]['invoice_data']['countryCode'];
$currency = $json_data["authentication"]['invoice_data']['currency'];
$zipCode = $json_data["authentication"]['invoice_data']['zipCode'];

$invoiceDate = $json_data["authentication"]['invoice_data']['invoiceDate'];
$invoiceDate = str_replace('/', '-', $invoiceDate);
$final_invoice_date = date('Y-m-d', strtotime($invoiceDate));

$invoiceNumber = $json_data["authentication"]['invoice_data']['invoiceNumber'];
$eventCode = $json_data["authentication"]['invoice_data']['eventCode'];

$gstNumber = $json_data["authentication"]['invoice_data']['gstNumber'];
$sac = $json_data["authentication"]['invoice_data']['sac'];

$insert_data['custAccount'] = $code;
$insert_data['invoicedate'] = $final_invoice_date;
$insert_data['street'] = $street;
$insert_data['city'] = $cityCode;
$insert_data['cityDescription'] = $cityDescription;
$insert_data['state'] = $stateCode;
$insert_data['stateDescription'] = $stateDescription;
$insert_data['country'] = $countryCode;
$insert_data['zipCode'] = $zipCode;
$insert_data['invoicenumber'] = $invoiceNumber;
$insert_data['currency'] = $currency;
$insert_data['eventCode'] = $eventCode;
$insert_data['type'] = 'Business,Home';

$insert_data['gstNumber'] = $gstNumber;
$insert_data['sac'] = $sac;

$insert_data['vertical'] = 'BIEC';
$insert_data['location'] = 'BIEC';
if(!empty($json_data["authentication"]['invoice_data']['CancellationCharges'])){
  $insert_data['CancellationCharges'] = $json_data["authentication"]['invoice_data']['CancellationCharges'];  
}else{
  $insert_data['CancellationCharges'] = 0;
}

if(!empty($json_data["authentication"]['invoice_data']['leanPD'])){
  $insert_data['leanPD'] = $json_data["authentication"]['invoice_data']['leanPD'];  
}else{
  $insert_data['leanPD'] = 0;
}

if(!empty($json_data["authentication"]['invoice_data']['loyaltyDisc'])){
  $insert_data['loyaltyDisc'] = $json_data["authentication"]['invoice_data']['loyaltyDisc'];  
}else{
  $insert_data['loyaltyDisc'] = 0;
}

$insert_data['RepairsMaintReimb'] = $json_data["authentication"]['invoice_data']['miscellaneous'];

foreach ($json_data["authentication"]["invoice_data"] as $key => $value) {
    if(array_key_exists($key, $GLOBALS['accounts_array'])){
        $column_name = $GLOBALS['accounts_array'][$key];
        $insert_data[$column_name] = $value;
    }
}

$insert_id = $db_erp->query_insert("biecstagingftidb", $insert_data);

unset($insert_data);

if (!empty($insert_id)) {
    echo '{"response":"1","message":"success"}';
}

$db_erp->close();
die();
?>
