<?php

require("../config/config.php");

$invoice_data = @file_get_contents('php://input');

$json_data = json_decode($invoice_data, true);

if (empty($json_data)) {
    echo '{"response":"0","message":"Invalid JSON Format"}';
    die();
}

$api_key = $json_data["authentication"]["api_key"];

if (empty($api_key)) {
    echo '{"response":"0","message":"API key cannot be blank"}';
    die();
}

if ($api_key != GLOBAL_APP_API_KEY) {
    echo '{"response":"0","message":"Invalid API Key"}';
    die();
}

$vertical = $json_data["authentication"]["vertical"];

$code = $json_data["authentication"]["invoice_data"]["code"];
$street = $json_data["authentication"]['invoice_data']['street'];
$cityCode = $json_data["authentication"]['invoice_data']['cityCode'];
$cityDescription = $json_data["authentication"]['invoice_data']['cityDescription'];
$stateCode = $json_data["authentication"]['invoice_data']['stateCode'];
$stateDescription = $json_data["authentication"]['invoice_data']['stateDescription'];
$countryCode = $json_data["authentication"]['invoice_data']['countryCode'];
$currency = $json_data["authentication"]['invoice_data']['currency'];
$zipCode = $json_data["authentication"]['invoice_data']['zipCode'];

$invoiceDate = $json_data["authentication"]['invoice_data']['invoiceDate'];
$invoiceDate = str_replace('/', '-', $invoiceDate);
$final_invoice_date = date('Y-m-d', strtotime($invoiceDate));

$invoiceNumber = $json_data["authentication"]['invoice_data']['invoiceNumber'];
$eventCode = $json_data["authentication"]['invoice_data']['eventCode'];

if (strpos($code, 'MEM') !== false) {
    $code = ltrim(preg_replace("/[^0-9]/","",$code), '0');
}

$insert_data['custAccount'] = $code;
$insert_data['invoicedate'] = $final_invoice_date;
$insert_data['street'] = $street;
$insert_data['city'] = $cityCode;
$insert_data['cityDescription'] = $cityDescription;
$insert_data['state'] = $stateCode;
$insert_data['stateDescription'] = $stateDescription;
$insert_data['country'] = $countryCode;
$insert_data['zipCode'] = $zipCode;
$insert_data['invoicenumber'] = $invoiceNumber;
$insert_data['currency'] = $currency;
$insert_data['eventCode'] = $eventCode;
$insert_data['type'] = 'Business,Home';
$insert_data['vertical'] = 'IMTEX';
$insert_data['location'] = 'IMTEX';

$insert_data['gstNumber'] = $json_data["authentication"]['invoice_data']['gstNumber'];
$insert_data['sac'] = $json_data["authentication"]['invoice_data']['sac'];
        
if($vertical == "sponsorship"){
	$insert_data['SponsorshipCharges'] = $json_data["authentication"]['invoice_data']['invoiceAmount'];        
}else if($vertical == "catalogue"){
	$insert_data['AdCharges'] = $json_data["authentication"]['invoice_data']['invoiceAmount'];
}else if($vertical == "miscellaneous"){
	$insert_data['RepairsMaintReimb'] = $json_data["authentication"]['invoice_data']['invoiceAmount'];
}

$insert_id = $db_erp->query_insert("imtexstagingftidb", $insert_data);

unset($insert_data);

if (!empty($insert_id)) {
    echo '{"response":"1","message":"success"}';
}

$db_erp->close();
die();
?>
