<?php

require("../config/config.php");

$invoice_data = @file_get_contents('php://input');

$json_data = json_decode($invoice_data, true);

if (empty($json_data)) {
    echo '{"response":"0","message":"Invalid JSON Format"}';
    die();
}

$api_key = $json_data["authentication"]["api_key"];

if (empty($api_key)) {
    echo '{"response":"0","message":"API key cannot be blank"}';
    die();
}

if ($api_key != GLOBAL_APP_API_KEY) {
    echo '{"response":"0","message":"Invalid API Key"}';
    die();
}

$vertical = $json_data["authentication"]["vertical"];

$insert_data['journalname'] = "";

$code = $json_data["authentication"]['receipt_data']['custAccount'];
if (strpos($code, 'MEM') !== false) {
    $code = ltrim(preg_replace("/[^0-9]/","",$code), '0');
}

$insert_data['custaccount'] = $code;
$insert_data['markedinvoice'] = $json_data["authentication"]['receipt_data']['markedInvoice'];
$paymentMode = $json_data["authentication"]['receipt_data']['paymentMode'];

$is_pre_payment = 0;
if($json_data["authentication"]['receipt_data']['prePayment']=="Yes"){
	$is_pre_payment = 1;
}
$insert_data['prepayment'] = $is_pre_payment;

if($paymentMode == "Demand Draft"){
    $insert_data['paymmode'] = "DD"; 
}else if($paymentMode == "TDS Certificate"){
    $insert_data['paymmode'] = "TDS"; 
}else{
    $insert_data['paymmode'] = $paymentMode; 
}

if($json_data["authentication"]['receipt_data']['paymentMode']=="Cash"){
	$insert_data['isCash'] = 1;
}
//$insert_data['bankaccount'] = $json_data["authentication"]['receipt_data']['backAccount'];
$insert_data['bankaccount'] = "";

$transdate = $json_data["authentication"]['receipt_data']['transDate'];
$transdate = str_replace('/', '-', $transdate);
$final_transdate = date('Y-m-d', strtotime($transdate));

$insert_data['transdate'] = $final_transdate;
$insert_data['amount'] = $json_data["authentication"]['receipt_data']['amount'];
$insert_data['currency'] = $json_data["authentication"]['receipt_data']['currency'];
$insert_data['event'] = $json_data["authentication"]['receipt_data']['event'];
$insert_data['location'] = $json_data["authentication"]['receipt_data']['location'];
$insert_data['documentNo'] = $json_data["authentication"]['receipt_data']['documentNo'];

$insert_data['gstNumber'] = $json_data["authentication"]['receipt_data']['gstNumber'];
$insert_data['sac'] = $json_data["authentication"]['receipt_data']['sac'];
$insert_data['stateCode'] = $json_data["authentication"]['receipt_data']['stateCode'];

//if($json_data["authentication"]['receipt_data']['location']=="Tooltech"){
//   $insert_data['vertical'] = "Tooltech"; 
//}else{
//   $insert_data['vertical'] = "IMTEX";
//}
$insert_data['vertical'] = $json_data["authentication"]['receipt_data']['location'];

$insert_id = $db_erp->query_insert("imtexpaymjournalstagingdb", $insert_data);

if (!empty($insert_id)) {
    echo '{"response":"1","message":"success"}';
}
unset($insert_data);

$db_erp->close();
die();
?>
