<?php

require("../config/config.php");

$data = @file_get_contents('php://input');

$json_data = json_decode($data, true);

if (empty($json_data)) {
    echo '{"response":"0","message":"Invalid JSON Format"}';
    die();
}

$api_key = $json_data["authentication"]["api_key"];

if (empty($api_key)) {
    echo '{"response":"0","message":"API key cannot be blank"}';
    die();
}

if ($api_key != GLOBAL_APP_API_KEY) {
    echo '{"response":"0","message":"Invalid API Key"}';
    die();
}

$vertical = $json_data["authentication"]["data"]["vertical"];
$name = $json_data["authentication"]['data']['name'];
$code = $json_data["authentication"]['data']['code'];

$originalDate = $json_data["authentication"]['data']['start_date'];
$start_date = date("Y-m-d", strtotime($originalDate));

$originalEndDate = $json_data["authentication"]['data']['end_date'];
$end_date = date("Y-m-d", strtotime($originalEndDate));

$table_name = "imtexeventdb";

$insert_data['value'] = $code;

$insert_data['description'] = $name;
$insert_data['eventStartDate'] = $start_date;
$insert_data['eventEndDate'] = $end_date;

$recordID = $db_erp->query_insert($table_name, $insert_data);
$db_erp->close();

if (!empty($recordID)) {
    $db = new mysqlconnect(DB_IMTEX_SERVER, DB_IMTEX_USER, DB_IMTEX_PASS, DB_IMTEX_DATABASE);
    $db->connect();
    $update_date['is_pushed'] = 1;

    $db->query_update("biec_mmi_magazines", $update_date, "magazine_code='" . $code . "'");
    unset($update_date);
	
	$db->query_update("biec_events", $update_date, "event_code='" . $code . "'");
    unset($update_date);
	
    echo '{"response":"1","message":"Success"}';
}

die();
?>
