<?php

require("../config/config.php");

$member_data = @file_get_contents('php://input');

$json_data = json_decode($member_data, true);

if (empty($json_data)) {
    echo '{"response":"0","message":"Invalid JSON Format"}';
    die();
}

$api_key = $json_data["authentication"]["api_key"];

if (empty($api_key)) {
    echo '{"response":"0","message":"API key cannot be blank"}';
    die();
}

if ($api_key != GLOBAL_APP_API_KEY) {
    echo '{"response":"0","message":"Invalid API Key"}';
    die();
}

$membershipNumber = $json_data["authentication"]["invoice_data"]["membershipNumber"];
$companyName = $json_data["authentication"]['invoice_data']['companyName'];
$street = $json_data["authentication"]['invoice_data']['street'];
$cityDescription = $json_data["authentication"]['invoice_data']['cityDescription'];
$cityCode = $json_data["authentication"]['invoice_data']['cityCode'];
$stateDescription = $json_data["authentication"]['invoice_data']['stateDescription'];
$stateCode = $json_data["authentication"]['invoice_data']['stateCode'];
$countryCode = $json_data["authentication"]['invoice_data']['countryCode'];
$currency = $json_data["authentication"]['invoice_data']['currency'];
$zipCode = $json_data["authentication"]['invoice_data']['zipCode'];

$invoiceDate = $json_data["authentication"]['invoice_data']['invoiceDate'];
$entranceAmount = $json_data["authentication"]['invoice_data']['entranceAmount'];
$membSubFee = $json_data["authentication"]['invoice_data']['subscriptionAmount'];
$invoiceNumber = $json_data["authentication"]['invoice_data']['invoiceNumber'];

$sac = $json_data["authentication"]['invoice_data']['sac'];
$gstNumber = $json_data["authentication"]['invoice_data']['gstNumber'];

$extract_number = ltrim(preg_replace("/[^0-9]/","",$membershipNumber), '0');
$insert_data['custAccount'] = $extract_number;

$insert_data['type'] = "Business, Home";
$insert_data['street'] = $street;
$insert_data['city'] = $cityCode;
$insert_data['cityDescription'] = $cityDescription;
$insert_data['state'] = $stateCode;
$insert_data['stateDescription'] = $stateDescription;
$insert_data['country'] = $countryCode;
$insert_data['zipCode'] = $zipCode;
$insert_data['currency'] = $currency;
$insert_data['invoicedate'] = $invoiceDate;
$insert_data['invoicenumber'] = $invoiceNumber;

$insert_data['sac'] = $sac;
$insert_data['gstNumber'] = $gstNumber;

$insert_data['EntranceFee'] = $entranceAmount;
$insert_data['membSubFee'] = $membSubFee;
$insert_data['vertical'] = "MEMBERSHIP";

$insert_id = $db_erp->query_insert("membershipstagingftidb", $insert_data);

unset($insert_data);

if (!empty($insert_id)) {
    echo '{"response":"1","message":"success"}';
}

$db_erp->close();
die();
?>
